
#include "FS803A.h"
#include "af901x.h"
//#include <math.h>
#include "FS_tuner.h"
#include "FS_tuner_globals.h"
#include "FS_i2c.h"
#include "FS_tuner_settings.h"

#define p_reg_top_gpio1on	0xD735
#define reg_top_gpio1on_pos	4
int MC44S803_tuner_init (int rf_agc_sel, int if_out_sel);
int MC44S803_select_RFagc_IFout ( int rf_agc_sel, int if_out_sel);

int MC44S803_tune (int freq);
int mc44s803_adjust_lna_gain ();

int MC44S803_i2c_read_tuner_reg (GENERIC_STRUCT_T *tuner_reg);
int MC44S803_i2c_xmit_tuner_reg (GENERIC_STRUCT_T *tuner_reg);


U8Data    handle_;
U8Data	demodAddress_;
U8Data	tunerAddress_;
U8Data	slaveDemod_;

extern TUNER_REGS_T g_regs;


UData_t InitFS803(
    Handle_t        handle,
    U8Data          ucDemod2WireAddr,
    U8Data          ucSlaveDemod,
    U8Data		    ucTuner2WireAddr,
    void *		    pData               // pointer to IF1 (Hz)
)
{
    UData_t      dwError = 0;
    U8Data       ucTemp = 3; // Initialize GPIO1 output=0

	
    deb_data("enter InitFS803\n");
    deb_data("ucDemod2WireAddr = 0x%X\n", ucDemod2WireAddr);
    deb_data("ucSlaveDemod = %d\n", ucSlaveDemod);
    deb_data("ucTuner2WireAddr = 0x%X\n", ucTuner2WireAddr);
     
	handle_         = handle;
	demodAddress_   = ucDemod2WireAddr;
	tunerAddress_   = ucTuner2WireAddr;
	slaveDemod_     = ucSlaveDemod;
	
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_reg_top_gpio1on, reg_top_gpio1on_pos, 3, ucTemp);
    dwError = MC44S803_tuner_init (LNAAGC_AGCSEL_RF0, CIRCUITADJ_IF_OUT_DIGITAL);

    return (dwError);
    
exit:
    return (dwError);
}


UData_t SetFS803(
    Handle_t        handle,
    U8Data      ucDemod2WireAddr,
    U8Data      ucSlaveDemod,
    U8Data		ucTuner2WireAddr,
    UData_t		dwFreq,
    U8Data      ucBw
)
{

	UData_t      dwError = 0;
	
	handle_         = handle;
	demodAddress_   = ucDemod2WireAddr;
	tunerAddress_   = ucTuner2WireAddr;
	slaveDemod_     = ucSlaveDemod;


	dwError = MC44S803_tune ((int)(dwFreq * 1000));

	return (dwError);

exit:

	return(dwError);
}

UData_t AdjustFS803(
    Handle_t        handle,
    U8Data      ucDemod2WireAddr,
    U8Data      ucSlaveDemod,
    U8Data		ucTuner2WireAddr,
    U8Data      ucStrong
)
{
	return (0);
}

UData_t CalibrateFS803(
    Handle_t        handle,
    U8Data      ucDemod2WireAddr,
    U8Data      ucSlaveDemod,
    U8Data      ucTuner2WireAddr,
    UData_t     f_in,
	UData_t     f_out,
    UData_t*    f_IF1,
    SData_t*    P_max,
    void *      pf,
    void *      pp
)
{
	return (0);
}
